// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Line Format Request.
 */
public class BaseWorkbookChartLineFormatRequest extends BaseRequest implements IBaseWorkbookChartLineFormatRequest {

    /**
     * The request for the WorkbookChartLineFormat
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartLineFormatRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartLineFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartLineFormat> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartLineFormat from the service
     * @return The WorkbookChartLineFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartLineFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartLineFormat with a source
     * @param sourceWorkbookChartLineFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartLineFormat);
    }

    /**
     * Patches this WorkbookChartLineFormat with a source
     * @param sourceWorkbookChartLineFormat The source object with updates
     * @return The updated WorkbookChartLineFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartLineFormat patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartLineFormat);
    }

    /**
     * Creates a WorkbookChartLineFormat with a new object
     * @param newWorkbookChartLineFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartLineFormat newWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartLineFormat);
    }

    /**
     * Creates a WorkbookChartLineFormat with a new object
     * @param newWorkbookChartLineFormat The new object to create
     * @return The created WorkbookChartLineFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartLineFormat post(final WorkbookChartLineFormat newWorkbookChartLineFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartLineFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartLineFormatRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartLineFormatRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartLineFormatRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartLineFormatRequest)this;
     }

}

