// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Person Collection Request.
 */
public class BasePersonCollectionRequest extends BaseCollectionRequest<BasePersonCollectionResponse, IPersonCollectionPage> implements IBasePersonCollectionRequest {

    /**
     * The request builder for this collection of Person
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BasePersonCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BasePersonCollectionResponse.class, IPersonCollectionPage.class);
    }

    public void get(final ICallback<IPersonCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IPersonCollectionPage get() throws ClientException {
        final BasePersonCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Person newPerson, final ICallback<Person> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new PersonRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newPerson, callback);
    }

    public Person post(final Person newPerson) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new PersonRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newPerson);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IPersonCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (PersonCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IPersonCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (PersonCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IPersonCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (PersonCollectionRequest)this;
    }

    public IPersonCollectionPage buildFromResponse(final BasePersonCollectionResponse response) {
        final IPersonCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new PersonCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final PersonCollectionPage page = new PersonCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
