// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Section Collection Request Builder.
 */
public class BaseOnenoteSectionCollectionRequestBuilder extends BaseRequestBuilder implements IBaseOnenoteSectionCollectionRequestBuilder {

    /**
     * The request builder for this collection of SectionGroup
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenoteSectionCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IOnenoteSectionCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IOnenoteSectionCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new OnenoteSectionCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IOnenoteSectionRequestBuilder byId(final String id) {
        return new OnenoteSectionRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
