// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base List Item Collection Request.
 */
public class BaseListItemCollectionRequest extends BaseCollectionRequest<BaseListItemCollectionResponse, IListItemCollectionPage> implements IBaseListItemCollectionRequest {

    /**
     * The request builder for this collection of ListItem
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseListItemCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseListItemCollectionResponse.class, IListItemCollectionPage.class);
    }

    public void get(final ICallback<IListItemCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IListItemCollectionPage get() throws ClientException {
        final BaseListItemCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ListItem newListItem, final ICallback<ListItem> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ListItemRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newListItem, callback);
    }

    public ListItem post(final ListItem newListItem) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ListItemRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newListItem);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IListItemCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ListItemCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IListItemCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ListItemCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IListItemCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ListItemCollectionRequest)this;
    }

    public IListItemCollectionPage buildFromResponse(final BaseListItemCollectionResponse response) {
        final IListItemCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ListItemCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ListItemCollectionPage page = new ListItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
