/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IProfilePhotoCollectionPage;
import com.microsoft.graph.extensions.IProfilePhotoCollectionRequest;
import com.microsoft.graph.extensions.ProfilePhoto;
import com.microsoft.graph.extensions.ProfilePhotoCollectionPage;
import com.microsoft.graph.extensions.ProfilePhotoCollectionRequest;
import com.microsoft.graph.extensions.ProfilePhotoCollectionRequestBuilder;
import com.microsoft.graph.extensions.ProfilePhotoRequestBuilder;
import com.microsoft.graph.generated.BaseProfilePhotoCollectionResponse;
import com.microsoft.graph.generated.IBaseProfilePhotoCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseProfilePhotoCollectionRequest
extends BaseCollectionRequest<BaseProfilePhotoCollectionResponse, IProfilePhotoCollectionPage>
implements IBaseProfilePhotoCollectionRequest {
    public BaseProfilePhotoCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseProfilePhotoCollectionResponse.class, IProfilePhotoCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IProfilePhotoCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseProfilePhotoCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IProfilePhotoCollectionPage get() throws ClientException {
        BaseProfilePhotoCollectionResponse response = (BaseProfilePhotoCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ProfilePhoto newProfilePhoto, ICallback<ProfilePhoto> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newProfilePhoto, callback);
    }

    @Override
    public ProfilePhoto post(ProfilePhoto newProfilePhoto) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ProfilePhotoRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newProfilePhoto);
    }

    @Override
    public IProfilePhotoCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ProfilePhotoCollectionRequest)this;
    }

    @Override
    public IProfilePhotoCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ProfilePhotoCollectionRequest)this;
    }

    @Override
    public IProfilePhotoCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ProfilePhotoCollectionRequest)this;
    }

    public IProfilePhotoCollectionPage buildFromResponse(BaseProfilePhotoCollectionResponse response) {
        ProfilePhotoCollectionRequestBuilder builder = response.nextLink != null ? new ProfilePhotoCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ProfilePhotoCollectionPage page = new ProfilePhotoCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

