/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Domain;
import com.microsoft.graph.extensions.DomainCollectionPage;
import com.microsoft.graph.extensions.DomainCollectionRequest;
import com.microsoft.graph.extensions.DomainCollectionRequestBuilder;
import com.microsoft.graph.extensions.DomainRequestBuilder;
import com.microsoft.graph.extensions.IDomainCollectionPage;
import com.microsoft.graph.extensions.IDomainCollectionRequest;
import com.microsoft.graph.generated.BaseDomainCollectionResponse;
import com.microsoft.graph.generated.IBaseDomainCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDomainCollectionRequest
extends BaseCollectionRequest<BaseDomainCollectionResponse, IDomainCollectionPage>
implements IBaseDomainCollectionRequest {
    public BaseDomainCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDomainCollectionResponse.class, IDomainCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDomainCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDomainCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDomainCollectionPage get() throws ClientException {
        BaseDomainCollectionResponse response = (BaseDomainCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Domain newDomain, ICallback<Domain> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DomainRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDomain, callback);
    }

    @Override
    public Domain post(Domain newDomain) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DomainRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDomain);
    }

    @Override
    public IDomainCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DomainCollectionRequest)this;
    }

    @Override
    public IDomainCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DomainCollectionRequest)this;
    }

    @Override
    public IDomainCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DomainCollectionRequest)this;
    }

    public IDomainCollectionPage buildFromResponse(BaseDomainCollectionResponse response) {
        DomainCollectionRequestBuilder builder = response.nextLink != null ? new DomainCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DomainCollectionPage page = new DomainCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

