// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Pivot Table Collection Request.
 */
public class BaseWorkbookPivotTableCollectionRequest extends BaseCollectionRequest<BaseWorkbookPivotTableCollectionResponse, IWorkbookPivotTableCollectionPage> implements IBaseWorkbookPivotTableCollectionRequest {

    /**
     * The request builder for this collection of WorkbookPivotTable
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookPivotTableCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookPivotTableCollectionResponse.class, IWorkbookPivotTableCollectionPage.class);
    }

    public void get(final ICallback<IWorkbookPivotTableCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IWorkbookPivotTableCollectionPage get() throws ClientException {
        final BaseWorkbookPivotTableCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final WorkbookPivotTable newWorkbookPivotTable, final ICallback<WorkbookPivotTable> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new WorkbookPivotTableRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newWorkbookPivotTable, callback);
    }

    public WorkbookPivotTable post(final WorkbookPivotTable newWorkbookPivotTable) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new WorkbookPivotTableRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newWorkbookPivotTable);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IWorkbookPivotTableCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IWorkbookPivotTableCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IWorkbookPivotTableCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookPivotTableCollectionRequest)this;
    }

    public IWorkbookPivotTableCollectionPage buildFromResponse(final BaseWorkbookPivotTableCollectionResponse response) {
        final IWorkbookPivotTableCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new WorkbookPivotTableCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final WorkbookPivotTableCollectionPage page = new WorkbookPivotTableCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
