// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Notebook Request.
 */
public class BaseNotebookRequest extends BaseRequest implements IBaseNotebookRequest {

    /**
     * The request for the Notebook
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseNotebookRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the Notebook from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Notebook> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Notebook from the service
     * @return The Notebook from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Notebook get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Notebook with a source
     * @param sourceNotebook The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Notebook sourceNotebook, final ICallback<Notebook> callback) {
        send(HttpMethod.PATCH, callback, sourceNotebook);
    }

    /**
     * Patches this Notebook with a source
     * @param sourceNotebook The source object with updates
     * @return The updated Notebook
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Notebook patch(final Notebook sourceNotebook) throws ClientException {
        return send(HttpMethod.PATCH, sourceNotebook);
    }

    /**
     * Creates a Notebook with a new object
     * @param newNotebook The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Notebook newNotebook, final ICallback<Notebook> callback) {
        send(HttpMethod.POST, callback, newNotebook);
    }

    /**
     * Creates a Notebook with a new object
     * @param newNotebook The new object to create
     * @return The created Notebook
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Notebook post(final Notebook newNotebook) throws ClientException {
        return send(HttpMethod.POST, newNotebook);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public INotebookRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (NotebookRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public INotebookRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (NotebookRequest)this;
     }

}

