/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ISiteCollectionPage;
import com.microsoft.graph.extensions.ISiteCollectionRequest;
import com.microsoft.graph.extensions.Site;
import com.microsoft.graph.extensions.SiteCollectionPage;
import com.microsoft.graph.extensions.SiteCollectionRequest;
import com.microsoft.graph.extensions.SiteCollectionRequestBuilder;
import com.microsoft.graph.extensions.SiteRequestBuilder;
import com.microsoft.graph.generated.BaseSiteCollectionResponse;
import com.microsoft.graph.generated.IBaseSiteCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseSiteCollectionRequest
extends BaseCollectionRequest<BaseSiteCollectionResponse, ISiteCollectionPage>
implements IBaseSiteCollectionRequest {
    public BaseSiteCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSiteCollectionResponse.class, ISiteCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISiteCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSiteCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteCollectionPage get() throws ClientException {
        BaseSiteCollectionResponse response = (BaseSiteCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Site newSite, ICallback<Site> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSite, callback);
    }

    @Override
    public Site post(Site newSite) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSite);
    }

    @Override
    public ISiteCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SiteCollectionRequest)this;
    }

    @Override
    public ISiteCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SiteCollectionRequest)this;
    }

    @Override
    public ISiteCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SiteCollectionRequest)this;
    }

    public ISiteCollectionPage buildFromResponse(BaseSiteCollectionResponse response) {
        SiteCollectionRequestBuilder builder = response.nextLink != null ? new SiteCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SiteCollectionPage page = new SiteCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

