// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Axis Title Request.
 */
public interface IBaseWorkbookChartAxisTitleRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxisTitle from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Gets the WorkbookChartAxisTitle from the service
     * @return The WorkbookChartAxisTitle from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitle get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxisTitle with a source
     * @param sourceWorkbookChartAxisTitle The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Patches this WorkbookChartAxisTitle with a source
     * @param sourceWorkbookChartAxisTitle The source object with updates
     * @return The updated WorkbookChartAxisTitle
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitle patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle) throws ClientException;

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     * @param newWorkbookChartAxisTitle The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     * @param newWorkbookChartAxisTitle The new object to create
     * @return The created WorkbookChartAxisTitle
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitle post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartAxisTitleRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartAxisTitleRequest expand(final String value);

}
