// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Axes Request.
 */
public interface IBaseWorkbookChartAxesRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxes from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartAxes> callback);

    /**
     * Gets the WorkbookChartAxes from the service
     * @return The WorkbookChartAxes from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxes get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxes with a source
     * @param sourceWorkbookChartAxes The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartAxes sourceWorkbookChartAxes, final ICallback<WorkbookChartAxes> callback);

    /**
     * Patches this WorkbookChartAxes with a source
     * @param sourceWorkbookChartAxes The source object with updates
     * @return The updated WorkbookChartAxes
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxes patch(final WorkbookChartAxes sourceWorkbookChartAxes) throws ClientException;

    /**
     * Posts a WorkbookChartAxes with a new object
     * @param newWorkbookChartAxes The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartAxes newWorkbookChartAxes, final ICallback<WorkbookChartAxes> callback);

    /**
     * Posts a WorkbookChartAxes with a new object
     * @param newWorkbookChartAxes The new object to create
     * @return The created WorkbookChartAxes
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxes post(final WorkbookChartAxes newWorkbookChartAxes) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartAxesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartAxesRequest expand(final String value);

}
