// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner Task Request.
 */
public interface IBasePlannerTaskRequest extends IHttpRequest {

    /**
     * Gets the PlannerTask from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<PlannerTask> callback);

    /**
     * Gets the PlannerTask from the service
     * @return The PlannerTask from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerTask get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerTask with a source
     * @param sourcePlannerTask The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final PlannerTask sourcePlannerTask, final ICallback<PlannerTask> callback);

    /**
     * Patches this PlannerTask with a source
     * @param sourcePlannerTask The source object with updates
     * @return The updated PlannerTask
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerTask patch(final PlannerTask sourcePlannerTask) throws ClientException;

    /**
     * Posts a PlannerTask with a new object
     * @param newPlannerTask The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final PlannerTask newPlannerTask, final ICallback<PlannerTask> callback);

    /**
     * Posts a PlannerTask with a new object
     * @param newPlannerTask The new object to create
     * @return The created PlannerTask
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerTask post(final PlannerTask newPlannerTask) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerTaskRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerTaskRequest expand(final String value);

}
