// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Operation Request.
 */
public interface IBaseOperationRequest extends IHttpRequest {

    /**
     * Gets the Operation from the service
     * @param callback The callback to be called after success or failure.
     */
    void getOperation(final ICallback<Operation> callback);

    /**
     * Gets the Operation from the service
     * @return The Operation from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Operation getOperation() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Operation with a source
     * @param sourceOperation The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Operation sourceOperation, final ICallback<Operation> callback);

    /**
     * Patches this Operation with a source
     * @param sourceOperation The source object with updates
     * @return The updated Operation
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Operation patch(final Operation sourceOperation) throws ClientException;

    /**
     * Posts a Operation with a new object
     * @param newOperation The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Operation newOperation, final ICallback<Operation> callback);

    /**
     * Posts a Operation with a new object
     * @param newOperation The new object to create
     * @return The created Operation
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Operation post(final Operation newOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseOperationRequest expand(final String value);

}
