// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Notebook Request.
 */
public interface IBaseNotebookRequest extends IHttpRequest {

    /**
     * Gets the Notebook from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Notebook> callback);

    /**
     * Gets the Notebook from the service
     * @return The Notebook from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Notebook get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Notebook with a source
     * @param sourceNotebook The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Notebook sourceNotebook, final ICallback<Notebook> callback);

    /**
     * Patches this Notebook with a source
     * @param sourceNotebook The source object with updates
     * @return The updated Notebook
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Notebook patch(final Notebook sourceNotebook) throws ClientException;

    /**
     * Posts a Notebook with a new object
     * @param newNotebook The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Notebook newNotebook, final ICallback<Notebook> callback);

    /**
     * Posts a Notebook with a new object
     * @param newNotebook The new object to create
     * @return The created Notebook
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Notebook post(final Notebook newNotebook) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseNotebookRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseNotebookRequest expand(final String value);

}
