// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Event Request.
 */
public interface IBaseEventRequest extends IHttpRequest {

    /**
     * Gets the Event from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Event> callback);

    /**
     * Gets the Event from the service
     * @return The Event from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Event get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Event with a source
     * @param sourceEvent The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Event sourceEvent, final ICallback<Event> callback);

    /**
     * Patches this Event with a source
     * @param sourceEvent The source object with updates
     * @return The updated Event
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Event patch(final Event sourceEvent) throws ClientException;

    /**
     * Posts a Event with a new object
     * @param newEvent The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Event newEvent, final ICallback<Event> callback);

    /**
     * Posts a Event with a new object
     * @param newEvent The new object to create
     * @return The created Event
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Event post(final Event newEvent) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseEventRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseEventRequest expand(final String value);

}
