// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Row Collection Request Builder.
 */
public class BaseWorkbookTableRowCollectionRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookTableRowCollectionRequestBuilder {

    /**
     * The request builder for this collection of WorkbookTable
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookTableRowCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IWorkbookTableRowCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IWorkbookTableRowCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new WorkbookTableRowCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IWorkbookTableRowRequestBuilder byId(final String id) {
        return new WorkbookTableRowRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IWorkbookTableRowAddRequestBuilder getAdd(final Integer index, final com.google.gson.JsonElement values) {
        return new WorkbookTableRowAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, index, values);
    }

    public IWorkbookTableRowItemAtRequestBuilder getItemAt(final Integer index) {
        return new WorkbookTableRowItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, index);
    }

    public IWorkbookTableRowCountRequestBuilder getCount() {
        return new WorkbookTableRowCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }
}
