// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Week Num Request Builder.
 */
public class BaseWorkbookFunctionsWeekNumRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsWeekNum
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsWeekNumRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("serialNumber", serialNumber);
        mBodyParams.put("returnType", returnType);
    }

    /**
     * Creates the IWorkbookFunctionsWeekNumRequest
     *
     * @return The IWorkbookFunctionsWeekNumRequest instance
     */
    public IWorkbookFunctionsWeekNumRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsWeekNumRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsWeekNumRequest instance
     */
    public IWorkbookFunctionsWeekNumRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsWeekNumRequest request = new WorkbookFunctionsWeekNumRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("serialNumber")) {
            request.mBody.serialNumber = getParameter("serialNumber");
        }

        if (hasParameter("returnType")) {
            request.mBody.returnType = getParameter("returnType");
        }

        return request;
    }
}
