// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Text Request Builder.
 */
public class BaseWorkbookFunctionsTextRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsText
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsTextRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement value, final com.google.gson.JsonElement formatText) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("value", value);
        mBodyParams.put("formatText", formatText);
    }

    /**
     * Creates the IWorkbookFunctionsTextRequest
     *
     * @return The IWorkbookFunctionsTextRequest instance
     */
    public IWorkbookFunctionsTextRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsTextRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsTextRequest instance
     */
    public IWorkbookFunctionsTextRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsTextRequest request = new WorkbookFunctionsTextRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("value")) {
            request.mBody.value = getParameter("value");
        }

        if (hasParameter("formatText")) {
            request.mBody.formatText = getParameter("formatText");
        }

        return request;
    }
}
