// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Nper Request Builder.
 */
public class BaseWorkbookFunctionsNperRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsNper
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsNperRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement rate, final com.google.gson.JsonElement pmt, final com.google.gson.JsonElement pv, final com.google.gson.JsonElement fv, final com.google.gson.JsonElement type) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("rate", rate);
        mBodyParams.put("pmt", pmt);
        mBodyParams.put("pv", pv);
        mBodyParams.put("fv", fv);
        mBodyParams.put("type", type);
    }

    /**
     * Creates the IWorkbookFunctionsNperRequest
     *
     * @return The IWorkbookFunctionsNperRequest instance
     */
    public IWorkbookFunctionsNperRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsNperRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsNperRequest instance
     */
    public IWorkbookFunctionsNperRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsNperRequest request = new WorkbookFunctionsNperRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("rate")) {
            request.mBody.rate = getParameter("rate");
        }

        if (hasParameter("pmt")) {
            request.mBody.pmt = getParameter("pmt");
        }

        if (hasParameter("pv")) {
            request.mBody.pv = getParameter("pv");
        }

        if (hasParameter("fv")) {
            request.mBody.fv = getParameter("fv");
        }

        if (hasParameter("type")) {
            request.mBody.type = getParameter("type");
        }

        return request;
    }
}
