// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Atan2Request Builder.
 */
public class BaseWorkbookFunctionsAtan2RequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsAtan2
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsAtan2RequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement xNum, final com.google.gson.JsonElement yNum) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("xNum", xNum);
        mBodyParams.put("yNum", yNum);
    }

    /**
     * Creates the IWorkbookFunctionsAtan2Request
     *
     * @return The IWorkbookFunctionsAtan2Request instance
     */
    public IWorkbookFunctionsAtan2Request buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsAtan2Request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsAtan2Request instance
     */
    public IWorkbookFunctionsAtan2Request buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsAtan2Request request = new WorkbookFunctionsAtan2Request(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("xNum")) {
            request.mBody.xNum = getParameter("xNum");
        }

        if (hasParameter("yNum")) {
            request.mBody.yNum = getParameter("yNum");
        }

        return request;
    }
}
