// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Sharing Invitation.
 */
public class BaseSharingInvitation implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose(serialize = false)
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager getAdditionalDataManager() {
        return additionalDataManager;
    }

    public BaseSharingInvitation() {
        oDataType = "microsoft.graph.sharingInvitation";
    }

    /**
     * The Email.
	 * The email address provided for the recipient of the sharing invitation. Read-only.
     */
    @SerializedName("email")
    @Expose
    public String email;

    /**
     * The Invited By.
	 * Provides information about who sent the invitation that created this permission, if that information is available. Read-only.
     */
    @SerializedName("invitedBy")
    @Expose
    public IdentitySet invitedBy;

    /**
     * The Redeemed By.
	 * 
     */
    @SerializedName("redeemedBy")
    @Expose
    public String redeemedBy;

    /**
     * The Sign In Required.
	 * If true the recipient of the invitation needs to sign in in order to access the shared item. Read-only.
     */
    @SerializedName("signInRequired")
    @Expose
    public Boolean signInRequired;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
