// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Share Point Request.
 */
public class BaseSharePointRequest extends BaseRequest implements IBaseSharePointRequest {

    /**
     * The request for the SharePoint
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseSharePointRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the SharePoint from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<SharePoint> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SharePoint from the service
     * @return The SharePoint from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharePoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this SharePoint with a source
     * @param sourceSharePoint The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final SharePoint sourceSharePoint, final ICallback<SharePoint> callback) {
        send(HttpMethod.PATCH, callback, sourceSharePoint);
    }

    /**
     * Patches this SharePoint with a source
     * @param sourceSharePoint The source object with updates
     * @return The updated SharePoint
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharePoint patch(final SharePoint sourceSharePoint) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharePoint);
    }

    /**
     * Creates a SharePoint with a new object
     * @param newSharePoint The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final SharePoint newSharePoint, final ICallback<SharePoint> callback) {
        send(HttpMethod.POST, callback, newSharePoint);
    }

    /**
     * Creates a SharePoint with a new object
     * @param newSharePoint The new object to create
     * @return The created SharePoint
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public SharePoint post(final SharePoint newSharePoint) throws ClientException {
        return send(HttpMethod.POST, newSharePoint);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public ISharePointRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (SharePointRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public ISharePointRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (SharePointRequest)this;
     }

}
