// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Section Group Collection Request.
 */
public class BaseSectionGroupCollectionRequest extends BaseCollectionRequest<BaseSectionGroupCollectionResponse, ISectionGroupCollectionPage> implements IBaseSectionGroupCollectionRequest {

    /**
     * The request builder for this collection of SectionGroup
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseSectionGroupCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSectionGroupCollectionResponse.class, ISectionGroupCollectionPage.class);
    }

    public void get(final ICallback<ISectionGroupCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISectionGroupCollectionPage get() throws ClientException {
        final BaseSectionGroupCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final SectionGroup newSectionGroup, final ICallback<SectionGroup> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SectionGroupRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSectionGroup, callback);
    }

    public SectionGroup post(final SectionGroup newSectionGroup) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SectionGroupRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSectionGroup);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public ISectionGroupCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SectionGroupCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public ISectionGroupCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SectionGroupCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public ISectionGroupCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SectionGroupCollectionRequest)this;
    }

    public ISectionGroupCollectionPage buildFromResponse(final BaseSectionGroupCollectionResponse response) {
        final ISectionGroupCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SectionGroupCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SectionGroupCollectionPage page = new SectionGroupCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
