// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Page Preview Request.
 */
public class BaseOnenotePagePreviewRequest extends BaseRequest implements IBaseOnenotePagePreviewRequest {

    /**
     * The request for this OnenotePagePreview
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenotePagePreviewRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenotePagePreview.class);
    }

    /**
     * Gets the OnenotePagePreview
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<OnenotePagePreview> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OnenotePagePreview
     *
     * @return The OnenotePagePreview
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public OnenotePagePreview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IOnenotePagePreviewRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (OnenotePagePreviewRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IOnenotePagePreviewRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (OnenotePagePreviewRequest)this;
    }

}
