// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Page Collection Request.
 */
public class BaseOnenotePageCollectionRequest extends BaseCollectionRequest<BaseOnenotePageCollectionResponse, IOnenotePageCollectionPage> implements IBaseOnenotePageCollectionRequest {

    /**
     * The request builder for this collection of OnenotePage
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenotePageCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOnenotePageCollectionResponse.class, IOnenotePageCollectionPage.class);
    }

    public void get(final ICallback<IOnenotePageCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IOnenotePageCollectionPage get() throws ClientException {
        final BaseOnenotePageCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final byte[] newOnenotePage, final ICallback<OnenotePage> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new OnenotePageRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getOptions())
                .post(newOnenotePage, callback);
    }

    public OnenotePage post(final byte[] newOnenotePage) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new OnenotePageRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getOptions())
                .post(newOnenotePage);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IOnenotePageCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (OnenotePageCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IOnenotePageCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (OnenotePageCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IOnenotePageCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (OnenotePageCollectionRequest)this;
    }

    public IOnenotePageCollectionPage buildFromResponse(final BaseOnenotePageCollectionResponse response) {
        final IOnenotePageCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new OnenotePageCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final OnenotePageCollectionPage page = new OnenotePageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
