// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Entity Schema Object Model Request.
 */
public class BaseOnenoteEntitySchemaObjectModelRequest extends BaseRequest implements IBaseOnenoteEntitySchemaObjectModelRequest {

    /**
     * The request for the OnenoteEntitySchemaObjectModel
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseOnenoteEntitySchemaObjectModelRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the OnenoteEntitySchemaObjectModel from the service
     * @param callback The callback to be called after success or failure.
     */
    public void getOnenoteEntitySchemaObjectModel(final ICallback<OnenoteEntitySchemaObjectModel> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OnenoteEntitySchemaObjectModel from the service
     * @return The OnenoteEntitySchemaObjectModel from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteEntitySchemaObjectModel getOnenoteEntitySchemaObjectModel() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this OnenoteEntitySchemaObjectModel with a source
     * @param sourceOnenoteEntitySchemaObjectModel The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final OnenoteEntitySchemaObjectModel sourceOnenoteEntitySchemaObjectModel, final ICallback<OnenoteEntitySchemaObjectModel> callback) {
        send(HttpMethod.PATCH, callback, sourceOnenoteEntitySchemaObjectModel);
    }

    /**
     * Patches this OnenoteEntitySchemaObjectModel with a source
     * @param sourceOnenoteEntitySchemaObjectModel The source object with updates
     * @return The updated OnenoteEntitySchemaObjectModel
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteEntitySchemaObjectModel patch(final OnenoteEntitySchemaObjectModel sourceOnenoteEntitySchemaObjectModel) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     * @param newOnenoteEntitySchemaObjectModel The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel, final ICallback<OnenoteEntitySchemaObjectModel> callback) {
        send(HttpMethod.POST, callback, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Creates a OnenoteEntitySchemaObjectModel with a new object
     * @param newOnenoteEntitySchemaObjectModel The new object to create
     * @return The created OnenoteEntitySchemaObjectModel
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteEntitySchemaObjectModel post(final OnenoteEntitySchemaObjectModel newOnenoteEntitySchemaObjectModel) throws ClientException {
        return send(HttpMethod.POST, newOnenoteEntitySchemaObjectModel);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IOnenoteEntitySchemaObjectModelRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OnenoteEntitySchemaObjectModelRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IOnenoteEntitySchemaObjectModelRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OnenoteEntitySchemaObjectModelRequest)this;
     }

}
