// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Inference Classification Request.
 */
public class BaseInferenceClassificationRequest extends BaseRequest implements IBaseInferenceClassificationRequest {

    /**
     * The request for the InferenceClassification
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseInferenceClassificationRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the InferenceClassification from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<InferenceClassification> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the InferenceClassification from the service
     * @return The InferenceClassification from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public InferenceClassification get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this InferenceClassification with a source
     * @param sourceInferenceClassification The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final InferenceClassification sourceInferenceClassification, final ICallback<InferenceClassification> callback) {
        send(HttpMethod.PATCH, callback, sourceInferenceClassification);
    }

    /**
     * Patches this InferenceClassification with a source
     * @param sourceInferenceClassification The source object with updates
     * @return The updated InferenceClassification
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public InferenceClassification patch(final InferenceClassification sourceInferenceClassification) throws ClientException {
        return send(HttpMethod.PATCH, sourceInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     * @param newInferenceClassification The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final InferenceClassification newInferenceClassification, final ICallback<InferenceClassification> callback) {
        send(HttpMethod.POST, callback, newInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     * @param newInferenceClassification The new object to create
     * @return The created InferenceClassification
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public InferenceClassification post(final InferenceClassification newInferenceClassification) throws ClientException {
        return send(HttpMethod.POST, newInferenceClassification);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IInferenceClassificationRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (InferenceClassificationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IInferenceClassificationRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (InferenceClassificationRequest)this;
     }

}
