// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Site Get By Path Request.
 */
public interface IBaseSiteGetByPathRequest {

    /**
     * Patches the SiteGetByPath
     *
     * @param srcSite The Site with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    void patch(Site srcSite, final ICallback<Site> callback);

    /**
     * Patches the SiteGetByPath
     *
     * @param srcSite The Site with which to PATCH
     * @return The Site
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    Site patch(Site srcSite) throws ClientException;

    /**
     * Puts the SiteGetByPath
     *
     * @param srcSite The Site to PUT
     * @param callback The callback to be called after success or failure
     */
    void put(Site srcSite, final ICallback<Site> callback);

    /**
     * Puts the SiteGetByPath
     *
     * @param srcSite The Site to PUT
     * @return The Site
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     Site put(Site srcSite) throws ClientException;
    /**
     * Gets the Site
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Site> callback);

    /**
     * Gets the Site
     *
     * @return The Site
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    Site get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    ISiteGetByPathRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    ISiteGetByPathRequest expand(final String value);

}
