// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Request.
 */
public class BaseWorkbookFunctionsRequest extends BaseRequest implements IBaseWorkbookFunctionsRequest {

    /**
     * The request for the WorkbookFunctions
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookFunctionsRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookFunctions from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookFunctions> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookFunctions from the service
     * @return The WorkbookFunctions from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookFunctions get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookFunctions with a source
     * @param sourceWorkbookFunctions The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookFunctions sourceWorkbookFunctions, final ICallback<WorkbookFunctions> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookFunctions);
    }

    /**
     * Patches this WorkbookFunctions with a source
     * @param sourceWorkbookFunctions The source object with updates
     * @return The updated WorkbookFunctions
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookFunctions patch(final WorkbookFunctions sourceWorkbookFunctions) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     * @param newWorkbookFunctions The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookFunctions newWorkbookFunctions, final ICallback<WorkbookFunctions> callback) {
        send(HttpMethod.POST, callback, newWorkbookFunctions);
    }

    /**
     * Creates a WorkbookFunctions with a new object
     * @param newWorkbookFunctions The new object to create
     * @return The created WorkbookFunctions
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookFunctions post(final WorkbookFunctions newWorkbookFunctions) throws ClientException {
        return send(HttpMethod.POST, newWorkbookFunctions);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookFunctionsRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookFunctionsRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookFunctionsRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookFunctionsRequest)this;
     }

}
