// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Radians Request Builder.
 */
public class BaseWorkbookFunctionsRadiansRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsRadians
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsRadiansRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement angle) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("angle", angle);
    }

    /**
     * Creates the IWorkbookFunctionsRadiansRequest
     *
     * @return The IWorkbookFunctionsRadiansRequest instance
     */
    public IWorkbookFunctionsRadiansRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsRadiansRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsRadiansRequest instance
     */
    public IWorkbookFunctionsRadiansRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsRadiansRequest request = new WorkbookFunctionsRadiansRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("angle")) {
            request.mBody.angle = getParameter("angle");
        }

        return request;
    }
}
