// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Axis Request.
 */
public class BaseWorkbookChartAxisRequest extends BaseRequest implements IBaseWorkbookChartAxisRequest {

    /**
     * The request for the WorkbookChartAxis
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartAxisRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartAxis from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartAxis> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartAxis from the service
     * @return The WorkbookChartAxis from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxis get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartAxis with a source
     * @param sourceWorkbookChartAxis The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartAxis sourceWorkbookChartAxis, final ICallback<WorkbookChartAxis> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartAxis);
    }

    /**
     * Patches this WorkbookChartAxis with a source
     * @param sourceWorkbookChartAxis The source object with updates
     * @return The updated WorkbookChartAxis
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxis patch(final WorkbookChartAxis sourceWorkbookChartAxis) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartAxis);
    }

    /**
     * Creates a WorkbookChartAxis with a new object
     * @param newWorkbookChartAxis The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartAxis newWorkbookChartAxis, final ICallback<WorkbookChartAxis> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartAxis);
    }

    /**
     * Creates a WorkbookChartAxis with a new object
     * @param newWorkbookChartAxis The new object to create
     * @return The created WorkbookChartAxis
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxis post(final WorkbookChartAxis newWorkbookChartAxis) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartAxis);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartAxisRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartAxisRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartAxisRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartAxisRequest)this;
     }

}
