// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Section Request.
 */
public class BaseOnenoteSectionRequest extends BaseRequest implements IBaseOnenoteSectionRequest {

    /**
     * The request for the OnenoteSection
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseOnenoteSectionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the OnenoteSection from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<OnenoteSection> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OnenoteSection from the service
     * @return The OnenoteSection from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteSection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this OnenoteSection with a source
     * @param sourceOnenoteSection The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final OnenoteSection sourceOnenoteSection, final ICallback<OnenoteSection> callback) {
        send(HttpMethod.PATCH, callback, sourceOnenoteSection);
    }

    /**
     * Patches this OnenoteSection with a source
     * @param sourceOnenoteSection The source object with updates
     * @return The updated OnenoteSection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteSection patch(final OnenoteSection sourceOnenoteSection) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenoteSection);
    }

    /**
     * Creates a OnenoteSection with a new object
     * @param newOnenoteSection The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final OnenoteSection newOnenoteSection, final ICallback<OnenoteSection> callback) {
        send(HttpMethod.POST, callback, newOnenoteSection);
    }

    /**
     * Creates a OnenoteSection with a new object
     * @param newOnenoteSection The new object to create
     * @return The created OnenoteSection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OnenoteSection post(final OnenoteSection newOnenoteSection) throws ClientException {
        return send(HttpMethod.POST, newOnenoteSection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IOnenoteSectionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OnenoteSectionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IOnenoteSectionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OnenoteSectionRequest)this;
     }

}
