// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object With Reference Request.
 */
public class BaseDirectoryObjectWithReferenceRequest extends BaseRequest implements IBaseDirectoryObjectWithReferenceRequest {

    /**
     * The request for the DirectoryObject
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDirectoryObjectWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObject.class);
    }

    public void post(final DirectoryObject newDirectoryObject, final IJsonBackedObject payload, final ICallback<DirectoryObject> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public DirectoryObject post(final DirectoryObject newDirectoryObject, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newDirectoryObject;
        }
        return null;
    }

    public void get(final ICallback<DirectoryObject> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public DirectoryObject get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDirectoryObjectWithReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (IDirectoryObjectWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDirectoryObjectWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (DirectoryObjectWithReferenceRequest)this;
    }
}
