/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookTableCollectionPage;
import com.microsoft.graph.extensions.IWorkbookTableCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTable;
import com.microsoft.graph.extensions.WorkbookTableCollectionPage;
import com.microsoft.graph.extensions.WorkbookTableCollectionRequest;
import com.microsoft.graph.extensions.WorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookTableRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookTableCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookTableCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookTableCollectionRequest
extends BaseCollectionRequest<BaseWorkbookTableCollectionResponse, IWorkbookTableCollectionPage>
implements IBaseWorkbookTableCollectionRequest {
    public BaseWorkbookTableCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookTableCollectionResponse.class, IWorkbookTableCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookTableCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookTableCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookTableCollectionPage get() throws ClientException {
        BaseWorkbookTableCollectionResponse response = (BaseWorkbookTableCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookTable newWorkbookTable, ICallback<WorkbookTable> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookTable, callback);
    }

    @Override
    public WorkbookTable post(WorkbookTable newWorkbookTable) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookTableRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookTable);
    }

    @Override
    public IWorkbookTableCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookTableCollectionRequest)this;
    }

    @Override
    public IWorkbookTableCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookTableCollectionRequest)this;
    }

    @Override
    public IWorkbookTableCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookTableCollectionRequest)this;
    }

    public IWorkbookTableCollectionPage buildFromResponse(BaseWorkbookTableCollectionResponse response) {
        WorkbookTableCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookTableCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookTableCollectionPage page = new WorkbookTableCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

