// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner Plan Details Request.
 */
public interface IBasePlannerPlanDetailsRequest extends IHttpRequest {

    /**
     * Gets the PlannerPlanDetails from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<PlannerPlanDetails> callback);

    /**
     * Gets the PlannerPlanDetails from the service
     * @return The PlannerPlanDetails from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerPlanDetails get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerPlanDetails with a source
     * @param sourcePlannerPlanDetails The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final PlannerPlanDetails sourcePlannerPlanDetails, final ICallback<PlannerPlanDetails> callback);

    /**
     * Patches this PlannerPlanDetails with a source
     * @param sourcePlannerPlanDetails The source object with updates
     * @return The updated PlannerPlanDetails
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerPlanDetails patch(final PlannerPlanDetails sourcePlannerPlanDetails) throws ClientException;

    /**
     * Posts a PlannerPlanDetails with a new object
     * @param newPlannerPlanDetails The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final PlannerPlanDetails newPlannerPlanDetails, final ICallback<PlannerPlanDetails> callback);

    /**
     * Posts a PlannerPlanDetails with a new object
     * @param newPlannerPlanDetails The new object to create
     * @return The created PlannerPlanDetails
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerPlanDetails post(final PlannerPlanDetails newPlannerPlanDetails) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerPlanDetailsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerPlanDetailsRequest expand(final String value);

}
