// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner Bucket Task Board Task Format Request.
 */
public interface IBasePlannerBucketTaskBoardTaskFormatRequest extends IHttpRequest {

    /**
     * Gets the PlannerBucketTaskBoardTaskFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Gets the PlannerBucketTaskBoardTaskFormat from the service
     * @return The PlannerBucketTaskBoardTaskFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerBucketTaskBoardTaskFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerBucketTaskBoardTaskFormat with a source
     * @param sourcePlannerBucketTaskBoardTaskFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final PlannerBucketTaskBoardTaskFormat sourcePlannerBucketTaskBoardTaskFormat, final ICallback<PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Patches this PlannerBucketTaskBoardTaskFormat with a source
     * @param sourcePlannerBucketTaskBoardTaskFormat The source object with updates
     * @return The updated PlannerBucketTaskBoardTaskFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerBucketTaskBoardTaskFormat patch(final PlannerBucketTaskBoardTaskFormat sourcePlannerBucketTaskBoardTaskFormat) throws ClientException;

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     * @param newPlannerBucketTaskBoardTaskFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat, final ICallback<PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     * @param newPlannerBucketTaskBoardTaskFormat The new object to create
     * @return The created PlannerBucketTaskBoardTaskFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    PlannerBucketTaskBoardTaskFormat post(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerBucketTaskBoardTaskFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerBucketTaskBoardTaskFormatRequest expand(final String value);

}
