// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Planner Task.
 */
public class BasePlannerTask extends Entity implements IJsonBackedObject {


    public BasePlannerTask() {
        oDataType = "microsoft.graph.plannerTask";
    }

    /**
     * The Created By.
	 * 
     */
    @SerializedName("createdBy")
    @Expose
    public IdentitySet createdBy;

    /**
     * The Plan Id.
	 * 
     */
    @SerializedName("planId")
    @Expose
    public String planId;

    /**
     * The Bucket Id.
	 * 
     */
    @SerializedName("bucketId")
    @Expose
    public String bucketId;

    /**
     * The Title.
	 * 
     */
    @SerializedName("title")
    @Expose
    public String title;

    /**
     * The Order Hint.
	 * 
     */
    @SerializedName("orderHint")
    @Expose
    public String orderHint;

    /**
     * The Assignee Priority.
	 * 
     */
    @SerializedName("assigneePriority")
    @Expose
    public String assigneePriority;

    /**
     * The Percent Complete.
	 * 
     */
    @SerializedName("percentComplete")
    @Expose
    public Integer percentComplete;

    /**
     * The Start Date Time.
	 * 
     */
    @SerializedName("startDateTime")
    @Expose
    public java.util.Calendar startDateTime;

    /**
     * The Created Date Time.
	 * 
     */
    @SerializedName("createdDateTime")
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Due Date Time.
	 * 
     */
    @SerializedName("dueDateTime")
    @Expose
    public java.util.Calendar dueDateTime;

    /**
     * The Has Description.
	 * 
     */
    @SerializedName("hasDescription")
    @Expose
    public Boolean hasDescription;

    /**
     * The Preview Type.
	 * 
     */
    @SerializedName("previewType")
    @Expose
    public PlannerPreviewType previewType;

    /**
     * The Completed Date Time.
	 * 
     */
    @SerializedName("completedDateTime")
    @Expose
    public java.util.Calendar completedDateTime;

    /**
     * The Completed By.
	 * 
     */
    @SerializedName("completedBy")
    @Expose
    public IdentitySet completedBy;

    /**
     * The Reference Count.
	 * 
     */
    @SerializedName("referenceCount")
    @Expose
    public Integer referenceCount;

    /**
     * The Checklist Item Count.
	 * 
     */
    @SerializedName("checklistItemCount")
    @Expose
    public Integer checklistItemCount;

    /**
     * The Active Checklist Item Count.
	 * 
     */
    @SerializedName("activeChecklistItemCount")
    @Expose
    public Integer activeChecklistItemCount;

    /**
     * The Applied Categories.
	 * 
     */
    @SerializedName("appliedCategories")
    @Expose
    public PlannerAppliedCategories appliedCategories;

    /**
     * The Assignments.
	 * 
     */
    @SerializedName("assignments")
    @Expose
    public PlannerAssignments assignments;

    /**
     * The Conversation Thread Id.
	 * 
     */
    @SerializedName("conversationThreadId")
    @Expose
    public String conversationThreadId;

    /**
     * The Details.
	 * 
     */
    @SerializedName("details")
    @Expose
    public PlannerTaskDetails details;

    /**
     * The Assigned To Task Board Format.
	 * 
     */
    @SerializedName("assignedToTaskBoardFormat")
    @Expose
    public PlannerAssignedToTaskBoardTaskFormat assignedToTaskBoardFormat;

    /**
     * The Progress Task Board Format.
	 * 
     */
    @SerializedName("progressTaskBoardFormat")
    @Expose
    public PlannerProgressTaskBoardTaskFormat progressTaskBoardFormat;

    /**
     * The Bucket Task Board Format.
	 * 
     */
    @SerializedName("bucketTaskBoardFormat")
    @Expose
    public PlannerBucketTaskBoardTaskFormat bucketTaskBoardFormat;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
