/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IPlannerTaskCollectionPage;
import com.microsoft.graph.extensions.IPlannerTaskCollectionRequest;
import com.microsoft.graph.extensions.PlannerTask;
import com.microsoft.graph.extensions.PlannerTaskCollectionPage;
import com.microsoft.graph.extensions.PlannerTaskCollectionRequest;
import com.microsoft.graph.extensions.PlannerTaskCollectionRequestBuilder;
import com.microsoft.graph.extensions.PlannerTaskRequestBuilder;
import com.microsoft.graph.generated.BasePlannerTaskCollectionResponse;
import com.microsoft.graph.generated.IBasePlannerTaskCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BasePlannerTaskCollectionRequest
extends BaseCollectionRequest<BasePlannerTaskCollectionResponse, IPlannerTaskCollectionPage>
implements IBasePlannerTaskCollectionRequest {
    public BasePlannerTaskCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BasePlannerTaskCollectionResponse.class, IPlannerTaskCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerTaskCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePlannerTaskCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerTaskCollectionPage get() throws ClientException {
        BasePlannerTaskCollectionResponse response = (BasePlannerTaskCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerTask newPlannerTask, ICallback<PlannerTask> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPlannerTask, callback);
    }

    @Override
    public PlannerTask post(PlannerTask newPlannerTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerTaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPlannerTask);
    }

    @Override
    public IPlannerTaskCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (PlannerTaskCollectionRequest)this;
    }

    @Override
    public IPlannerTaskCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (PlannerTaskCollectionRequest)this;
    }

    @Override
    public IPlannerTaskCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (PlannerTaskCollectionRequest)this;
    }

    public IPlannerTaskCollectionPage buildFromResponse(BasePlannerTaskCollectionResponse response) {
        PlannerTaskCollectionRequestBuilder builder = response.nextLink != null ? new PlannerTaskCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerTaskCollectionPage page = new PlannerTaskCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

