// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Planner Request.
 */
public interface IBasePlannerRequest extends IHttpRequest {

    /**
     * Gets the Planner from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<Planner> callback);

    /**
     * Gets the Planner from the service
     * @return The Planner from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Planner get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Planner with a source
     * @param sourcePlanner The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final Planner sourcePlanner, final ICallback<Planner> callback);

    /**
     * Patches this Planner with a source
     * @param sourcePlanner The source object with updates
     * @return The updated Planner
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Planner patch(final Planner sourcePlanner) throws ClientException;

    /**
     * Posts a Planner with a new object
     * @param newPlanner The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final Planner newPlanner, final ICallback<Planner> callback);

    /**
     * Posts a Planner with a new object
     * @param newPlanner The new object to create
     * @return The created Planner
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    Planner post(final Planner newPlanner) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBasePlannerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBasePlannerRequest expand(final String value);

}
