// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Table Request Builder.
 */
public interface IBaseWorkbookTableRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IWorkbookTableRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IWorkbookTableRequest buildRequest(final List<Option> requestOptions);

    IWorkbookTableColumnCollectionRequestBuilder getColumns();

    IWorkbookTableColumnRequestBuilder getColumns(final String id);

    IWorkbookTableRowCollectionRequestBuilder getRows();

    IWorkbookTableRowRequestBuilder getRows(final String id);

    /**
     * Gets the request builder for WorkbookTableSort.
     */
    IWorkbookTableSortRequestBuilder getSort();

    /**
     * Gets the request builder for WorkbookWorksheet.
     */
    IWorkbookWorksheetRequestBuilder getWorksheet();
    IWorkbookTableClearFiltersRequestBuilder getClearFilters();
    IWorkbookTableConvertToRangeRequestBuilder getConvertToRange();
    IWorkbookTableReapplyFiltersRequestBuilder getReapplyFilters();
    IWorkbookTableDataBodyRangeRequestBuilder getDataBodyRange();
    IWorkbookTableHeaderRowRangeRequestBuilder getHeaderRowRange();
    IWorkbookTableRangeRequestBuilder getRange();
    IWorkbookTableTotalRowRangeRequestBuilder getTotalRowRange();

}
