// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Series Item At Request.
 */
public interface IBaseWorkbookChartSeriesItemAtRequest {

    /**
     * Patches the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries The WorkbookChartSeries with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    void patch(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<WorkbookChartSeries> callback);

    /**
     * Patches the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries The WorkbookChartSeries with which to PATCH
     * @return The WorkbookChartSeries
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    WorkbookChartSeries patch(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException;

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries The WorkbookChartSeries to PUT
     * @param callback The callback to be called after success or failure
     */
    void put(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<WorkbookChartSeries> callback);

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries The WorkbookChartSeries to PUT
     * @return The WorkbookChartSeries
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     WorkbookChartSeries put(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException;
    /**
     * Gets the WorkbookChartSeries
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartSeries> callback);

    /**
     * Gets the WorkbookChartSeries
     *
     * @return The WorkbookChartSeries
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    WorkbookChartSeries get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IWorkbookChartSeriesItemAtRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IWorkbookChartSeriesItemAtRequest expand(final String value);

}
