// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Line Format Request.
 */
public interface IBaseWorkbookChartLineFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartLineFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Gets the WorkbookChartLineFormat from the service
     * @return The WorkbookChartLineFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLineFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartLineFormat with a source
     * @param sourceWorkbookChartLineFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Patches this WorkbookChartLineFormat with a source
     * @param sourceWorkbookChartLineFormat The source object with updates
     * @return The updated WorkbookChartLineFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLineFormat patch(final WorkbookChartLineFormat sourceWorkbookChartLineFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLineFormat with a new object
     * @param newWorkbookChartLineFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartLineFormat newWorkbookChartLineFormat, final ICallback<WorkbookChartLineFormat> callback);

    /**
     * Posts a WorkbookChartLineFormat with a new object
     * @param newWorkbookChartLineFormat The new object to create
     * @return The created WorkbookChartLineFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartLineFormat post(final WorkbookChartLineFormat newWorkbookChartLineFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartLineFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartLineFormatRequest expand(final String value);

}
