// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range.
 */
public class BaseWorkbookRange extends Entity implements IJsonBackedObject {


    public BaseWorkbookRange() {
        oDataType = "microsoft.graph.workbookRange";
    }

    /**
     * The Address.
     */
    @SerializedName("address")
    @Expose
    public String address;

    /**
     * The Address Local.
     */
    @SerializedName("addressLocal")
    @Expose
    public String addressLocal;

    /**
     * The Cell Count.
     */
    @SerializedName("cellCount")
    @Expose
    public Integer cellCount;

    /**
     * The Column Count.
     */
    @SerializedName("columnCount")
    @Expose
    public Integer columnCount;

    /**
     * The Column Hidden.
     */
    @SerializedName("columnHidden")
    @Expose
    public Boolean columnHidden;

    /**
     * The Column Index.
     */
    @SerializedName("columnIndex")
    @Expose
    public Integer columnIndex;

    /**
     * The Formulas.
     */
    @SerializedName("formulas")
    @Expose
    public com.google.gson.JsonElement formulas;

    /**
     * The Formulas Local.
     */
    @SerializedName("formulasLocal")
    @Expose
    public com.google.gson.JsonElement formulasLocal;

    /**
     * The Formulas R1C1.
     */
    @SerializedName("formulasR1C1")
    @Expose
    public com.google.gson.JsonElement formulasR1C1;

    /**
     * The Hidden.
     */
    @SerializedName("hidden")
    @Expose
    public Boolean hidden;

    /**
     * The Number Format.
     */
    @SerializedName("numberFormat")
    @Expose
    public com.google.gson.JsonElement numberFormat;

    /**
     * The Row Count.
     */
    @SerializedName("rowCount")
    @Expose
    public Integer rowCount;

    /**
     * The Row Hidden.
     */
    @SerializedName("rowHidden")
    @Expose
    public Boolean rowHidden;

    /**
     * The Row Index.
     */
    @SerializedName("rowIndex")
    @Expose
    public Integer rowIndex;

    /**
     * The Text.
     */
    @SerializedName("text")
    @Expose
    public com.google.gson.JsonElement text;

    /**
     * The Value Types.
     */
    @SerializedName("valueTypes")
    @Expose
    public com.google.gson.JsonElement valueTypes;

    /**
     * The Values.
     */
    @SerializedName("values")
    @Expose
    public com.google.gson.JsonElement values;

    /**
     * The Format.
     */
    @SerializedName("format")
    @Expose
    public WorkbookRangeFormat format;

    /**
     * The Sort.
     */
    @SerializedName("sort")
    @Expose
    public WorkbookRangeSort sort;

    /**
     * The Worksheet.
     */
    @SerializedName("worksheet")
    @Expose
    public WorkbookWorksheet worksheet;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
