// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Vdb Request Builder.
 */
public class BaseWorkbookFunctionsVdbRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsVdb
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsVdbRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement cost, final com.google.gson.JsonElement salvage, final com.google.gson.JsonElement life, final com.google.gson.JsonElement startPeriod, final com.google.gson.JsonElement endPeriod, final com.google.gson.JsonElement factor, final com.google.gson.JsonElement noSwitch) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("cost", cost);
        mBodyParams.put("salvage", salvage);
        mBodyParams.put("life", life);
        mBodyParams.put("startPeriod", startPeriod);
        mBodyParams.put("endPeriod", endPeriod);
        mBodyParams.put("factor", factor);
        mBodyParams.put("noSwitch", noSwitch);
    }

    /**
     * Creates the IWorkbookFunctionsVdbRequest
     *
     * @return The IWorkbookFunctionsVdbRequest instance
     */
    public IWorkbookFunctionsVdbRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsVdbRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsVdbRequest instance
     */
    public IWorkbookFunctionsVdbRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsVdbRequest request = new WorkbookFunctionsVdbRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("cost")) {
            request.mBody.cost = getParameter("cost");
        }

        if (hasParameter("salvage")) {
            request.mBody.salvage = getParameter("salvage");
        }

        if (hasParameter("life")) {
            request.mBody.life = getParameter("life");
        }

        if (hasParameter("startPeriod")) {
            request.mBody.startPeriod = getParameter("startPeriod");
        }

        if (hasParameter("endPeriod")) {
            request.mBody.endPeriod = getParameter("endPeriod");
        }

        if (hasParameter("factor")) {
            request.mBody.factor = getParameter("factor");
        }

        if (hasParameter("noSwitch")) {
            request.mBody.noSwitch = getParameter("noSwitch");
        }

        return request;
    }
}
