// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Number Value Request Builder.
 */
public class BaseWorkbookFunctionsNumberValueRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsNumberValue
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsNumberValueRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement text, final com.google.gson.JsonElement decimalSeparator, final com.google.gson.JsonElement groupSeparator) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("text", text);
        mBodyParams.put("decimalSeparator", decimalSeparator);
        mBodyParams.put("groupSeparator", groupSeparator);
    }

    /**
     * Creates the IWorkbookFunctionsNumberValueRequest
     *
     * @return The IWorkbookFunctionsNumberValueRequest instance
     */
    public IWorkbookFunctionsNumberValueRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsNumberValueRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsNumberValueRequest instance
     */
    public IWorkbookFunctionsNumberValueRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsNumberValueRequest request = new WorkbookFunctionsNumberValueRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("text")) {
            request.mBody.text = getParameter("text");
        }

        if (hasParameter("decimalSeparator")) {
            request.mBody.decimalSeparator = getParameter("decimalSeparator");
        }

        if (hasParameter("groupSeparator")) {
            request.mBody.groupSeparator = getParameter("groupSeparator");
        }

        return request;
    }
}
