// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Collection Request Builder.
 */
public class BaseWorkbookChartCollectionRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookChartCollectionRequestBuilder {

    /**
     * The request builder for this collection of WorkbookWorksheet
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IWorkbookChartCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IWorkbookChartCollectionRequest buildRequest(final List<Option> requestOptions) {
        return new WorkbookChartCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IWorkbookChartRequestBuilder byId(final String id) {
        return new WorkbookChartRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IWorkbookChartAddRequestBuilder getAdd(final String type, final com.google.gson.JsonElement sourceData, final String seriesBy) {
        return new WorkbookChartAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, type, sourceData, seriesBy);
    }

    public IWorkbookChartItemRequestBuilder getItem(final String name) {
        return new WorkbookChartItemRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.item"), getClient(), null, name);
    }

    public IWorkbookChartItemAtRequestBuilder getItemAt(final Integer index) {
        return new WorkbookChartItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, index);
    }

    public IWorkbookChartCountRequestBuilder getCount() {
        return new WorkbookChartCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }
}
