// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Range Border Request.
 */
public interface IBaseWorkbookRangeBorderRequest extends IHttpRequest {

    /**
     * Gets the WorkbookRangeBorder from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookRangeBorder> callback);

    /**
     * Gets the WorkbookRangeBorder from the service
     * @return The WorkbookRangeBorder from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookRangeBorder get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookRangeBorder with a source
     * @param sourceWorkbookRangeBorder The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookRangeBorder sourceWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback);

    /**
     * Patches this WorkbookRangeBorder with a source
     * @param sourceWorkbookRangeBorder The source object with updates
     * @return The updated WorkbookRangeBorder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookRangeBorder patch(final WorkbookRangeBorder sourceWorkbookRangeBorder) throws ClientException;

    /**
     * Posts a WorkbookRangeBorder with a new object
     * @param newWorkbookRangeBorder The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookRangeBorder newWorkbookRangeBorder, final ICallback<WorkbookRangeBorder> callback);

    /**
     * Posts a WorkbookRangeBorder with a new object
     * @param newWorkbookRangeBorder The new object to create
     * @return The created WorkbookRangeBorder
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookRangeBorder post(final WorkbookRangeBorder newWorkbookRangeBorder) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookRangeBorderRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookRangeBorderRequest expand(final String value);

}
