// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Filter Request Builder.
 */
public interface IBaseWorkbookFilterRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     */
    IWorkbookFilterRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     */
    IWorkbookFilterRequest buildRequest(final List<Option> requestOptions);
    IWorkbookFilterApplyRequestBuilder getApply(final WorkbookFilterCriteria criteria);
    IWorkbookFilterApplyBottomItemsFilterRequestBuilder getApplyBottomItemsFilter(final Integer count);
    IWorkbookFilterApplyBottomPercentFilterRequestBuilder getApplyBottomPercentFilter(final Integer percent);
    IWorkbookFilterApplyCellColorFilterRequestBuilder getApplyCellColorFilter(final String color);
    IWorkbookFilterApplyCustomFilterRequestBuilder getApplyCustomFilter(final String criteria1, final String criteria2, final String oper);
    IWorkbookFilterApplyDynamicFilterRequestBuilder getApplyDynamicFilter(final String criteria);
    IWorkbookFilterApplyFontColorFilterRequestBuilder getApplyFontColorFilter(final String color);
    IWorkbookFilterApplyIconFilterRequestBuilder getApplyIconFilter(final WorkbookIcon icon);
    IWorkbookFilterApplyTopItemsFilterRequestBuilder getApplyTopItemsFilter(final Integer count);
    IWorkbookFilterApplyTopPercentFilterRequestBuilder getApplyTopPercentFilter(final Integer percent);
    IWorkbookFilterApplyValuesFilterRequestBuilder getApplyValuesFilter(final com.google.gson.JsonElement values);
    IWorkbookFilterClearRequestBuilder getClear();

}
