// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Column Add Request Builder.
 */
public class BaseWorkbookTableColumnAddRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookTableColumnAdd
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookTableColumnAddRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final Integer index, final com.google.gson.JsonElement values) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("index", index);
        mBodyParams.put("values", values);
    }

    /**
     * Creates the IWorkbookTableColumnAddRequest
     *
     * @return The IWorkbookTableColumnAddRequest instance
     */
    public IWorkbookTableColumnAddRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookTableColumnAddRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookTableColumnAddRequest instance
     */
    public IWorkbookTableColumnAddRequest buildRequest(final List<Option> requestOptions) {
        WorkbookTableColumnAddRequest request = new WorkbookTableColumnAddRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("index")) {
            request.mBody.index = getParameter("index");
        }

        if (hasParameter("values")) {
            request.mBody.values = getParameter("values");
        }

        return request;
    }
}
