// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Process Query Request Builder.
 */
public class BaseWorkbookProcessQueryRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookProcessQuery
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookProcessQueryRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final byte[] input) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("input", input);
    }

    /**
     * Creates the IWorkbookProcessQueryRequest
     *
     * @return The IWorkbookProcessQueryRequest instance
     */
    public IWorkbookProcessQueryRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookProcessQueryRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookProcessQueryRequest instance
     */
    public IWorkbookProcessQueryRequest buildRequest(final List<Option> requestOptions) {
        WorkbookProcessQueryRequest request = new WorkbookProcessQueryRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("input")) {
            request.mBody.input = getParameter("input");
        }

        return request;
    }
}
